function [x,fval]=powell(fct,p,maxit,ftol);


    
    tol=0.0001;
    n=length(p);
    xi=eye(n);
    fret=fct(p);
    pt=p;
    iter=0;
    not_converged=true;
    
    while not_converged;
        
        iter=iter+1;
%         fprintf('\n\n Powell Iteration Number %4.0f',iter); 
%         fprintf('      Function Value %9.5f',fret);
%         fprintf(' \n\n');
        fp=fret;
        ibig=1;
        del=0;
        i=1;
        while (i<=n);
            xit=xi(:,i);
            [xxs,fret]=linmin(@(xx) fct(p+xx*xit),0,0.5,tol,100);
            p=p+xxs*xit;
            if (abs(fp-fret)< del);
                del=abs(fp-fret);
                ibig=i;
            end
            i=i+1;
        end
        if (((2*abs(fp-fret))<= ftol*(abs(fp)+abs(fret)))&&(iter>1));
   
            not_converged=false;
        end
        if (iter==maxit)
            not_converged=false;
        end
        
        if not_converged
            ptt=2*p-pt;
            xit=p-pt;
            pt=p;
            fptt=fct(ptt);
            if (fptt < fp); 
                t=2*(fp-2*fret+fptt)*(fp-fret-del)^2-del*(fp-fptt)^2;
                if (t< 0); 
                    [xxs,fret]=linmin(@(xx) fct(p+xx*xit),0,0.3,tol,100);
                    p=p+xxs*xit;
                    xi(:,ibig)=xit;
                end
            end   
        end
        x=p;
        fval=fret;
    end
end